IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_CPL_DEMANDA_PARAMETRO_VALORES]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PROD_CPL_DEMANDA_PARAMETRO_VALORES]
GO  
--SELECT * FROM UFD_EST_PROD_CPL_DEMANDA_PARAMETRO_VALORES (1,2,7)
CREATE FUNCTION [dbo].[UFD_EST_PROD_CPL_DEMANDA_PARAMETRO_VALORES]  (@CD_EMP  INT,      
															@CD_FILIAL INT,  
															@CD_PROD INT)  
RETURNS @RS_TAB_COMIS TABLE (CD_CTR_DEMANDA_PARAMETRO  INT,  
							  TP_NIVEL	INT,  
							  PERC_VARIACAO	MONEY,   
							  CD_PROD		INT,  
							  CD_FILIAL   INT,  
							  CD_EMP		INT)  
WITH ENCRYPTION AS                
BEGIN                
          

DECLARE @RS_DADOS_TBL_PARAM AS TABLE (CD_CTR_DEMANDA_PARAMETRO INT, 
									  TP_NIVEL		INT, 
									  PERC_VARIACAO	MONEY)  

 -------------------------------------------------------------------------------------------------------------------------------      
 --DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO      
 -------------------------------------------------------------------------------------------------------------------------------      
 DECLARE @EST_PROD_ARV_MERC TABLE (  CD_EMP     INT,      
          CD_PROD   INT,      
          CD_ARV_MERC_CATEG INT,      
          CD_ARV_MERC_SEG INT,      
          CD_ARV_MERC_PAPEL INT,      
          CD_ARV_MERC_MIX INT,      
          CD_ARV_MERC_CONSUMO INT,      
          CD_ARV_MERC_LINHA INT,      
          CD_ARV_MERC_MTZ_BCG INT,      
          CD_MC   INT,      
          CD_ARV_MERC_FAMILIA INT,              
          CD_APRES   INT,          
          CD_ARV_MERC_EQUI INT,      
          CD_GRP_EXPO  INT,      
          CD_FABRIC   INT)      
            
 -------------------------------------------------------------------------------------------------------------------------------      
 --BUSCANDO ARVORE MERC. DO PRODUTO      
 -------------------------------------------------------------------------------------------------------------------------------       
	INSERT INTO @EST_PROD_ARV_MERC      
	SELECT       
		ARV.CD_EMP     ,      
		ARV.CD_PROD     ,      
		ARV.CD_ARV_MERC_CATEG  ,      
		ARV.CD_ARV_MERC_SEG   ,      
		ARV.CD_ARV_MERC_PAPEL  ,      
		ARV.CD_ARV_MERC_MIX   ,      
		ARV.CD_ARV_MERC_CONSUMO  ,      
		ARV.CD_ARV_MERC_LINHA  ,      
		ARV.CD_ARV_MERC_MTZ_BCG  ,      
		ARV.CD_MC     ,      
		ARV.CD_ARV_MERC_FAMILIA  ,              
		ARV.CD_APRES    ,          
		ARV.CD_ARV_MERC_EQUI  ,      
		ARV.CD_GRP_EXPO    ,      
		P.CD_FABRIC       
	FROM 
		EST_PROD_EST_ARV_MERCADOLOGICA ARV 
		INNER JOIN EST_PROD P ON      
		ARV.CD_EMP  = P.CD_EMP      
		AND ARV.CD_PROD = P.CD_PROD      
	WHERE   
		P.CD_EMP = @CD_EMP       
		AND P.CD_PROD = @CD_PROD;
           
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 1 - PRODUTOS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT TOP 1      
		A.CD_CTR AS CD_CTR_DEMANDA_PARAMETRO, 
		1 AS TIPO_NIVEL,	     
		B.PERC_VARIACAO
	FROM 
		EST_PROD_CPL_DEMANDA_PARAMETRO A   
		INNER JOIN EST_PROD_CPL_DEMANDA_PARAMETRO_EST_PROD B ON      
		A.CD_CTR = B.CD_CTR_DEMANDA_PARAMETRO      
		INNER JOIN EST_PROD_CPL_DEMANDA_PARAMETRO_PRC_FILIAL FIL ON      
		B.CD_EMP = FIL.CD_EMP AND      
		B.CD_CTR_DEMANDA_PARAMETRO = FIL.CD_CTR_DEMANDA_PARAMETRO      
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_PROD = ARV.CD_PROD             
	WHERE       
		FIL.CD_FILIAL = @CD_FILIAL      
		AND NOT EXISTS (SELECT 
						T.CD_CTR_DEMANDA_PARAMETRO 
					 FROM 
						@RS_DADOS_TBL_PARAM T 
					 WHERE 
						T.CD_CTR_DEMANDA_PARAMETRO = A.CD_CTR)      
   ORDER BY 
		A.DT_CAD DESC, 
		B.PERC_VARIACAO asc  
      
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 2 - FAMLIAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT TOP 1      
		A.CD_CTR AS CD_CTR_DEMANDA_PARAMETRO, 
		2 AS TIPO_NIVEL,	     
		B.PERC_VARIACAO    
	FROM 
		EST_PROD_CPL_DEMANDA_PARAMETRO A      
		INNER JOIN EST_PROD_CPL_DEMANDA_PARAMETRO_EST_ARV_MERC_FAMILIA B ON      
		A.CD_CTR = B.CD_CTR_DEMANDA_PARAMETRO      
		INNER JOIN EST_PROD_CPL_DEMANDA_PARAMETRO_PRC_FILIAL FIL ON      
		B.CD_EMP = FIL.CD_EMP AND      
		B.CD_CTR_DEMANDA_PARAMETRO = FIL.CD_CTR_DEMANDA_PARAMETRO      
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA      
	WHERE       
		FIL.CD_FILIAL = @CD_FILIAL AND         
		NOT EXISTS (SELECT 
						T.CD_CTR_DEMANDA_PARAMETRO 
					FROM 
						@RS_DADOS_TBL_PARAM T 
					WHERE 
						T.CD_CTR_DEMANDA_PARAMETRO = A.CD_CTR)      
		ORDER BY 
			A.DT_CAD DESC, 
			B.PERC_VARIACAO DESC     
          
 -------------------------------------------------------------------------------------------------------------------------------          
 --Consultando as tbls de COMISSO no NVEL 3 - MARCAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT TOP 1      
		A.CD_CTR AS CD_CTR_DEMANDA_PARAMETRO, 
		3 AS TIPO_NIVEL,	     
		B.PERC_VARIACAO      
	FROM 
		EST_PROD_CPL_DEMANDA_PARAMETRO A     
		INNER JOIN EST_PROD_CPL_DEMANDA_PARAMETRO_EST_MC B ON       
		A.CD_CTR = B.CD_CTR_DEMANDA_PARAMETRO      
		INNER JOIN EST_PROD_CPL_DEMANDA_PARAMETRO_PRC_FILIAL FIL ON      
		B.CD_EMP = FIL.CD_EMP AND      
		B.CD_CTR_DEMANDA_PARAMETRO = FIL.CD_CTR_DEMANDA_PARAMETRO      
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_MC = ARV.CD_MC              
	WHERE       
		FIL.CD_FILIAL = @CD_FILIAL 
		AND NOT EXISTS (SELECT T.CD_CTR_DEMANDA_PARAMETRO 
							FROM @RS_DADOS_TBL_PARAM T 
							WHERE T.CD_CTR_DEMANDA_PARAMETRO = A.CD_CTR)      
	ORDER BY 
		A.DT_CAD DESC, 
		B.PERC_VARIACAO DESC;
      
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 4 - FABRICANTES      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT TOP 1      
		A.CD_CTR AS CD_CTR_DEMANDA_PARAMETRO, 
		4 AS TIPO_NIVEL,	     
		B.PERC_VARIACAO        
	FROM 
		EST_PROD_CPL_DEMANDA_PARAMETRO A      
		INNER JOIN EST_PROD_CPL_DEMANDA_PARAMETRO_EST_PROD_FABRIC B ON       
		A.CD_CTR = B.CD_CTR_DEMANDA_PARAMETRO      
		INNER JOIN EST_PROD_CPL_DEMANDA_PARAMETRO_PRC_FILIAL FIL ON      
		@CD_EMP = FIL.CD_EMP AND      
		B.CD_CTR_DEMANDA_PARAMETRO = FIL.CD_CTR_DEMANDA_PARAMETRO      
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_FABRIC = ARV.CD_FABRIC               
	WHERE       
		FIL.CD_FILIAL = @CD_FILIAL 
		AND NOT EXISTS (SELECT 
							T.CD_CTR_DEMANDA_PARAMETRO 
						FROM 
							@RS_DADOS_TBL_PARAM T 
						WHERE T.CD_CTR_DEMANDA_PARAMETRO = A.CD_CTR)      
	ORDER BY 
		A.DT_CAD DESC, 
		B.PERC_VARIACAO DESC;

-------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 5 - CATEGORIAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT TOP 1      
		A.CD_CTR AS CD_CTR_DEMANDA_PARAMETRO, 
		5 AS TIPO_NIVEL,	     
		B.PERC_VARIACAO      
	FROM 
		EST_PROD_CPL_DEMANDA_PARAMETRO A      
		INNER JOIN EST_PROD_CPL_DEMANDA_PARAMETRO_EST_ARV_MERC_CATEGORIA B ON      
		A.CD_CTR = B.CD_CTR_DEMANDA_PARAMETRO      
		INNER JOIN EST_PROD_CPL_DEMANDA_PARAMETRO_PRC_FILIAL FIL ON      
		B.CD_EMP = FIL.CD_EMP AND      
		B.CD_CTR_DEMANDA_PARAMETRO = FIL.CD_CTR_DEMANDA_PARAMETRO      
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND      
		B.CD_ARV_MERC_CATEG = ARV.CD_ARV_MERC_CATEG      
	WHERE       
		FIL.CD_FILIAL = @CD_FILIAL AND         
		NOT EXISTS (SELECT 
					T.CD_CTR_DEMANDA_PARAMETRO 
					FROM 
					@RS_DADOS_TBL_PARAM T 
					WHERE 
					T.CD_CTR_DEMANDA_PARAMETRO = A.CD_CTR)      
	ORDER BY 
		A.DT_CAD DESC, 
		B.PERC_VARIACAO DESC;
		
 ----------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de COMISSO no NVEL 6 - LINHAS      
 -----------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_PARAM       
	SELECT TOP 1      
		A.CD_CTR AS CD_CTR_DEMANDA_PARAMETRO, 
		6 AS TIPO_NIVEL,	     
		B.PERC_VARIACAO
	FROM 
		EST_PROD_CPL_DEMANDA_PARAMETRO A   
		INNER JOIN EST_PROD_CPL_DEMANDA_PARAMETRO_EST_ARV_MERC_LINHA B ON      
		A.CD_CTR = B.CD_CTR_DEMANDA_PARAMETRO      
		INNER JOIN EST_PROD_CPL_DEMANDA_PARAMETRO_PRC_FILIAL FIL ON      
		B.CD_EMP = FIL.CD_EMP AND      
		B.CD_CTR_DEMANDA_PARAMETRO = FIL.CD_CTR_DEMANDA_PARAMETRO      
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		B.CD_EMP = ARV.CD_EMP AND         
		B.CD_ARV_MERC_LINHA = ARV.CD_ARV_MERC_LINHA      
	WHERE       
		FIL.CD_FILIAL = @CD_FILIAL AND       
		NOT EXISTS (SELECT 
					T.CD_CTR_DEMANDA_PARAMETRO 
					FROM 
					@RS_DADOS_TBL_PARAM T 
					WHERE 
					T.CD_CTR_DEMANDA_PARAMETRO = A.CD_CTR)      
	ORDER BY 
		A.DT_CAD DESC, 
		B.PERC_VARIACAO ASC;

    
	INSERT INTO @RS_TAB_COMIS   
	SELECT TOP 1 
		CD_CTR_DEMANDA_PARAMETRO,  
		TP_NIVEL,
		PERC_VARIACAO,   
		@CD_PROD AS CD_PROD,  
		@CD_FILIAL AS CD_FILIAL,  
		@CD_EMP AS CD_EMP  
	FROM 
		@RS_DADOS_TBL_PARAM A  
	ORDER BY 
		TP_NIVEL ASC, 
		PERC_VARIACAO ASC  
  
RETURN  
  
END        
  